
import gurobi as gp

# Define variables
x = gp.multidict(['Peggy', 'John', 'Dale', 'Laura', 'Bill', 'Ringo', 'George'])[0]

# Objective function
model = gp.Model()
model.setObjective(2.61*x[0] + 5.96*x[1] + 2.97*x[2] + 9.77*x[3] + 8.75*x[4] + 2.62*x[5] + 4.41*x[6], gp.GRB.MINIMIZE)

# Constraints
# ... add all constraints here, for example:
model.addConstr(2.69*x[0] >= 0)
model.addConstr(0.28*x[0] >= 0)
# ... many more

# Add specific constraints as given
model.addConstr(1.01*x[2] + 1.18*x[4] >= 8)
model.addConstr(1.18*x[4] + 1.6*x[5] >= 12)
model.addConstr(1.18*x[4] + 0.8*x[6] >= 19)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print('Objective: %g' % model.objval)
    for i in range(7):
        print('x[%d] = %g' % (i, x[i].x))
else:
    print('No solution found')
