
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("military_optimization")

    # Create variables
    light_infantry = m.addVar(vtype=gp.GRB.INTEGER, name="light_infantry")
    mechanized_infantry = m.addVar(vtype=gp.GRB.INTEGER, name="mechanized_infantry")

    # Set objective function
    m.setObjective(5.17 * light_infantry + 6.54 * mechanized_infantry, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * light_infantry + 11 * mechanized_infantry >= 14, "logistics_footprint_min")
    m.addConstr(5 * light_infantry + 11 * mechanized_infantry >= 20, "logistical_capacity_min")
    m.addConstr(8 * light_infantry + 8 * mechanized_infantry >= 17, "defensive_capability_min")
    m.addConstr(2 * light_infantry - mechanized_infantry >= 0, "light_infantry_mechanized_infantry_relation")
    m.addConstr(4 * light_infantry + 11 * mechanized_infantry <= 31, "logistics_footprint_max")
    m.addConstr(5 * light_infantry + 11 * mechanized_infantry <= 64, "logistical_capacity_max")
    m.addConstr(8 * light_infantry + 8 * mechanized_infantry <= 31, "defensive_capability_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('light_infantry:', light_infantry.x)
        print('mechanized_infantry:', mechanized_infantry.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
