
from gurobipy import *

# Create a new model
m = Model("Infantry_Companies")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="mechanized_infantry_companies")

# Set objective function
m.setObjective(5.17*x1 + 6.54*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 11*x2 >= 14, "logistics_footprint_min")
m.addConstr(5*x1 + 11*x2 >= 20, "logistical_capacity_min")
m.addConstr(8*x1 + 8*x2 >= 17, "defensive_capability_rating_min")
m.addConstr(2*x1 - x2 >= 0, "mixed_constraint")
m.addConstr(4*x1 + 11*x2 <= 31, "logistics_footprint_max")
m.addConstr(5*x1 + 11*x2 <= 64, "logistical_capacity_max")
m.addConstr(8*x1 + 8*x2 <= 31, "defensive_capability_rating_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Light Infantry Companies: {x1.x}")
    print(f"Mechanized Infantry Companies: {x2.x}")
else:
    print("No optimal solution found")
