
import gurobi as gp

# Create a new model
m = gp.Model("infantry_companies")

# Define the variables
x0 = m.addVar(name="light_infantry_companies", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="mechanized_infantry_companies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(5.17 * x0 + 6.54 * x1, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * x0 + 11 * x1 >= 14, name="min_logistics_footprint")
m.addConstr(5 * x0 + 11 * x1 >= 20, name="min_logistical_capacity")
m.addConstr(8 * x0 + 8 * x1 >= 17, name="min_defensive_capability")
m.addConstr(2 * x0 - x1 >= 0, name="infantry_relationship")
m.addConstr(4 * x0 + 11 * x1 <= 31, name="max_logistics_footprint")
m.addConstr(5 * x0 + 11 * x1 <= 64, name="max_logistical_capacity")
m.addConstr(8 * x0 + 8 * x1 <= 31, name="max_defensive_capability")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Light Infantry Companies: {x0.varValue}")
    print(f"Mechanized Infantry Companies: {x1.varValue}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
