
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
paul = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="paul")
ringo = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ringo")
laura = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura")
hank = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank")
john = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="john")


# Set objective function
m.setObjective(3*paul + 7*ringo + 6*laura + 7*hank + 7*john, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(15*paul + 23*ringo >= 70)
m.addConstr(23*ringo + 20*hank >= 65)
m.addConstr(15*paul + 20*john >= 45)
m.addConstr(14*laura + 20*hank >= 48)
m.addConstr(15*paul + 14*laura >= 65)
m.addConstr(20*hank + 20*john >= 53)
m.addConstr(23*ringo + 14*laura >= 37)
m.addConstr(23*ringo + 20*hank + 20*john >= 67)
m.addConstr(15*paul + 20*hank + 20*john >= 67)
m.addConstr(15*paul + 23*ringo + 20*hank >= 67)
m.addConstr(14*laura + 20*hank + 20*john >= 67)
m.addConstr(15*paul + 23*ringo + 14*laura >= 67)
m.addConstr(15*paul + 23*ringo + 20*john >= 67)
m.addConstr(23*ringo + 14*laura + 20*hank >= 67)
m.addConstr(23*ringo + 20*hank + 20*john >= 70)
m.addConstr(15*paul + 20*hank + 20*john >= 70)
m.addConstr(15*paul + 23*ringo + 20*hank >= 70)
m.addConstr(14*laura + 20*hank + 20*john >= 70)
m.addConstr(15*paul + 23*ringo + 14*laura >= 70)
m.addConstr(15*paul + 23*ringo + 20*john >= 70)
m.addConstr(23*ringo + 14*laura + 20*hank >= 70)


# ... (rest of the work quality constraints - similar format as above)

# Computer competence constraints
m.addConstr(2*ringo + 14*hank >= 95)
m.addConstr(3*paul + 14*hank >= 76)
# ... (rest of the computer competence constraints)

# Productivity constraints
m.addConstr(7*paul + 22*hank >= 41)
m.addConstr(7*paul + 6*laura >= 42)
# ... (rest of the productivity constraints)

# Additional constraints
m.addConstr(-ringo + 7*laura >= 0)
m.addConstr(23*ringo + 14*laura + 20*hank <= 368)
# ... (rest of the additional constraints)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

