
from gurobipy import *

# Create a model
m = Model("Work Hours")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Paul")
x2 = m.addVar(vtype=GRB.INTEGER, lb=0, name="hours_worked_by_Ringo")
x3 = m.addVar(lb=0, name="hours_worked_by_Laura")
x4 = m.addVar(lb=0, name="hours_worked_by_Hank")
x5 = m.addVar(vtype=GRB.INTEGER, lb=0, name="hours_worked_by_John")

# Objective function (assuming no objective, just minimize 0)
m.setObjective(0)

# Constraints
m.addConstr(67*x1 + 72*x2 + 41*x3 + 91*x4 + 19*x5 >= 67, "Work_Quality")
m.addConstr(-x2 + 7*x3 >= 0, "Ringo_Laura_Constraint")

# Add all other constraints here...

# Solve the model
m.optimize()
