
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")
cereal = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cereal")
kale = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale")
potatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")


# Set objective function
m.setObjective(4.13 * strawberries + 9.93 * cereal + 2.98 * kale + 1.85 * potatoes, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.63 * strawberries + 8.36 * kale >= 21, "fiber_strawberries_kale")
m.addConstr(7.08 * cereal + 8.36 * kale >= 14, "fiber_cereal_kale")
m.addConstr(7.08 * cereal + 8.36 * kale + 2.7 * potatoes >= 22, "fiber_cereal_kale_potatoes1")
m.addConstr(3.63 * strawberries + 7.08 * cereal + 2.7 * potatoes >= 22, "fiber_strawberries_cereal_potatoes")
m.addConstr(7.08 * cereal + 8.36 * kale + 2.7 * potatoes >= 22, "fiber_cereal_kale_potatoes2")
m.addConstr(3.63 * strawberries + 7.08 * cereal + 2.7 * potatoes >= 22, "fiber_strawberries_cereal_potatoes2")
m.addConstr(3.63 * strawberries + 7.08 * cereal + 8.36 * kale + 2.7 * potatoes >= 22, "fiber_all")
m.addConstr(-10 * strawberries + 2 * cereal >= 0, "strawberries_cereal_ratio")
m.addConstr(-3 * strawberries + 10 * potatoes >= 0, "strawberries_potatoes_ratio")
m.addConstr(3.63 * strawberries + 7.08 * cereal <= 121, "fiber_strawberries_cereal_max")
m.addConstr(7.08 * cereal + 8.36 * kale + 2.7 * potatoes <= 69, "fiber_cereal_kale_potatoes_max")
m.addConstr(3.63 * strawberries + 7.08 * cereal + 8.36 * kale <= 42, "fiber_strawberries_cereal_kale_max")
m.addConstr(3.63 * strawberries + 7.08 * cereal + 2.7 * potatoes <= 53, "fiber_strawberries_cereal_potatoes_max")
m.addConstr(3.63 * strawberries + 7.08 * cereal + 8.36 * kale + 2.7 * potatoes <= 136, "fiber_total_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

