
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="strawberries", lb=0)
    x2 = model.addVar(name="bowls of cereal", lb=0)
    x3 = model.addVar(name="kale salads", lb=0)
    x4 = model.addVar(name="potatoes", lb=0)

    # Objective function
    model.setObjective(4.13 * x1 + 9.93 * x2 + 2.98 * x3 + 1.85 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(3.63 * x1 + 8.36 * x3 >= 21)
    model.addConstr(7.08 * x2 + 8.36 * x3 >= 14)
    model.addConstr(7.08 * x2 + 8.36 * x3 + 2.7 * x4 >= 22)
    model.addConstr(3.63 * x1 + 7.08 * x2 + 2.7 * x4 >= 22)
    model.addConstr(3.63 * x1 + 7.08 * x2 + 8.36 * x3 >= 22)
    model.addConstr(3.63 * x1 + 7.08 * x2 + 8.36 * x3 + 2.7 * x4 >= 22)
    model.addConstr(-10 * x1 + 2 * x2 >= 0)
    model.addConstr(-3 * x1 + 10 * x4 >= 0)
    model.addConstr(3.63 * x1 + 7.08 * x2 <= 121)
    model.addConstr(7.08 * x2 + 8.36 * x3 + 2.7 * x4 <= 69)
    model.addConstr(3.63 * x1 + 7.08 * x2 + 8.36 * x3 <= 42)
    model.addConstr(3.63 * x1 + 7.08 * x2 + 2.7 * x4 <= 53)
    model.addConstr(3.63 * x1 <= 136)
    model.addConstr(7.08 * x2 <= 136)
    model.addConstr(8.36 * x3 <= 136)
    model.addConstr(2.7 * x4 <= 136)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Strawberries: {x1.varValue}")
        print(f"Bowls of cereal: {x2.varValue}")
        print(f"Kale salads: {x3.varValue}")
        print(f"Potatoes: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
