
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    rubber_gloves = m.addVar(vtype=GRB.INTEGER, name="rubber_gloves")
    ibuprofen_bottles = m.addVar(vtype=GRB.INTEGER, name="ibuprofen_bottles")


    # Set objective function
    m.setObjective(5 * rubber_gloves + 2 * ibuprofen_bottles, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(4 * rubber_gloves + 2 * ibuprofen_bottles >= 15, "sustainability_min")
    m.addConstr(1 * rubber_gloves - 5 * ibuprofen_bottles >= 0, "glove_ibuprofen_ratio")
    m.addConstr(4 * rubber_gloves + 2 * ibuprofen_bottles <= 22, "sustainability_max")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Rubber Gloves: {rubber_gloves.x}")
        print(f"Bottles of Ibuprofen: {ibuprofen_bottles.x}")
        print(f"Objective Value: {m.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
