
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="rubber_gloves")
x2 = m.addVar(vtype=GRB.INTEGER, name="bottles_of_ibuprofen")

# Set the objective function
m.setObjective(5*x1 + 2*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 2*x2 >= 15, "sustainability_lower_bound")
m.addConstr(x1 - 5*x2 >= 0, "gloves_vs_bottles")
m.addConstr(4*x1 + 2*x2 <= 22, "sustainability_upper_bound")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rubber gloves: {x1.x}")
    print(f"Bottles of ibuprofen: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
