
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # rubber gloves
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # bottles of ibuprofen

    # Objective function: maximize 5*x1 + 2*x2
    model.setObjective(5*x1 + 2*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*x1 + 2*x2 >= 15, name="sustainability_score_min")
    model.addConstr(x1 - 5*x2 >= 0, name="rubber_gloves_vs_ibuprofen")
    model.addConstr(4*x1 + 2*x2 <= 22, name="sustainability_score_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"rubber gloves: {x1.varValue}")
        print(f"bottles of ibuprofen: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
