
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin C
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # grams of fiber
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2") # milligrams of vitamin B2


    # Set objective function
    m.setObjective(1.07 * x0 * x1 + 9.12 * x0 * x2 + 3.33 * x0, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11 * x0 <= 245, "c0")
    m.addConstr(15 * x0 <= 275, "c1")
    m.addConstr(4 * x1 <= 245, "c2")
    m.addConstr(5 * x1 <= 275, "c3")
    m.addConstr(5 * x2 <= 245, "c4")
    m.addConstr(x2 <= 275, "c5")
    m.addConstr(15 * x0 + x2 >= 43, "c6")
    m.addConstr(11 * x0 + 4 * x1 <= 203, "c7")
    m.addConstr(4 * x1 + 5 * x2 <= 184, "c8")
    m.addConstr(11 * x0 + 4 * x1 + 5 * x2 <= 184, "c9")
    m.addConstr(15 * x0 + 5 * x1 <= 179, "c10")
    m.addConstr(15 * x0 * x0 + x2 * x2 <= 234, "c11") # Note the squared terms
    m.addConstr(15 * x0 + 5 * x1 + x2 <= 234, "c12")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
