
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin C
    x1 = model.addVar(name="x1", lb=0)  # grams of fiber
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B2

    # Define the objective function
    model.setObjective(1.07 * x0 * x1 + 9.12 * x0 * x2 + 3.33 * x0, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(11 * x0 <= 245)
    model.addConstr(15 * x0 <= 275)
    model.addConstr(4 * x1 <= 245)
    model.addConstr(5 * x1 <= 275)
    model.addConstr(5 * x2 <= 245)
    model.addConstr(1 * x2 <= 275)
    model.addConstr(15 * x0 + 1 * x2 >= 43)
    model.addConstr(11 * x0 + 4 * x1 <= 203)
    model.addConstr(4 * x1 + 5 * x2 <= 184)
    model.addConstr(11 * x0 + 4 * x1 + 5 * x2 <= 184)
    model.addConstr(15 * x0 + 5 * x1 <= 179)
    model.addConstr(225 * x0**2 + x2**2 <= 54756)
    model.addConstr(15 * x0 + 5 * x1 + x2 <= 234)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x0.varValue}")
        print(f"Grams of fiber: {x1.varValue}")
        print(f"Milligrams of vitamin B2: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
