
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_work_hours")

# Create variables
dale_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
jean_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="jean_hours")
bill_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bill_hours")
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")


# Set objective function
m.setObjective(7.52 * dale_hours + 5.41 * jean_hours + 2.72 * bill_hours + 9.75 * laura_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4.64 * dale_hours + 4.12 * bill_hours >= 26)
m.addConstr(8.08 * jean_hours + 4.12 * bill_hours >= 20)
m.addConstr(4.64 * dale_hours + 8.08 * jean_hours >= 43)
m.addConstr(4.64 * dale_hours + 4.12 * bill_hours + 0.75 * laura_hours >= 27)
m.addConstr(4.64 * dale_hours + 8.08 * jean_hours + 4.12 * bill_hours + 0.75 * laura_hours >= 27)
m.addConstr(5.92 * bill_hours + 4.45 * laura_hours >= 27)
m.addConstr(6.34 * dale_hours + 4.69 * jean_hours >= 39)
m.addConstr(6.34 * dale_hours + 4.69 * jean_hours + 5.92 * bill_hours + 4.45 * laura_hours >= 39)
m.addConstr(dale_hours - 9 * bill_hours >= 0)
m.addConstr(4.12 * bill_hours + 0.75 * laura_hours <= 73)
m.addConstr(4.64 * dale_hours + 8.08 * jean_hours <= 171)
m.addConstr(4.64 * dale_hours + 0.75 * laura_hours <= 92)
m.addConstr(4.64 * dale_hours + 4.12 * bill_hours + 0.75 * laura_hours <= 118)
m.addConstr(5.92 * bill_hours + 4.45 * laura_hours <= 165)
m.addConstr(6.34 * dale_hours + 4.45 * laura_hours <= 86)
m.addConstr(6.34 * dale_hours + 5.92 * bill_hours <= 101)
m.addConstr(6.34 * dale_hours + 4.69 * jean_hours + 4.45 * laura_hours <= 123)
m.addConstr(6.34 * dale_hours + 4.69 * jean_hours + 5.92 * bill_hours <= 129)
m.addConstr(4.69 * jean_hours + 5.92 * bill_hours + 4.45 * laura_hours <= 152)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

