
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Dale
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Jean
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bill
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Laura

    # Define the objective function
    model.setObjective(7.52 * x0 + 5.41 * x1 + 2.72 * x2 + 9.75 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4.64 * x0 <= 195)
    model.addConstr(6.34 * x0 <= 171)
    model.addConstr(8.08 * x1 <= 195)
    model.addConstr(4.69 * x1 <= 171)
    model.addConstr(4.12 * x2 <= 195)
    model.addConstr(5.92 * x2 <= 171)
    model.addConstr(0.75 * x3 <= 195)
    model.addConstr(4.45 * x3 <= 171)
    model.addConstr(4.64 * x0 + 4.12 * x2 >= 26)
    model.addConstr(8.08 * x1 + 4.12 * x2 >= 20)
    model.addConstr(4.64 * x0 + 8.08 * x1 >= 43)
    model.addConstr(4.64 * x0 + 4.12 * x2 + 0.75 * x3 >= 27)
    model.addConstr(4.64 * x0 + 8.08 * x1 + 4.12 * x2 + 0.75 * x3 >= 27)
    model.addConstr(5.92 * x2 + 4.45 * x3 >= 27)
    model.addConstr(6.34 * x0 + 4.69 * x1 >= 39)
    model.addConstr(6.34 * x0 + 4.69 * x1 + 5.92 * x2 + 4.45 * x3 >= 39)
    model.addConstr(x0 - 9 * x2 >= 0)
    model.addConstr(4.12 * x2 + 0.75 * x3 <= 73)
    model.addConstr(4.64 * x0 + 8.08 * x1 <= 171)
    model.addConstr(4.64 * x0 + 0.75 * x3 <= 92)
    model.addConstr(4.64 * x0 + 4.12 * x2 + 0.75 * x3 <= 118)
    model.addConstr(5.92 * x2 + 4.45 * x3 <= 165)
    model.addConstr(6.34 * x0 + 4.45 * x3 <= 86)
    model.addConstr(6.34 * x0 + 5.92 * x2 <= 101)
    model.addConstr(6.34 * x0 + 4.69 * x1 + 4.45 * x3 <= 123)
    model.addConstr(6.34 * x0 + 4.69 * x1 + 5.92 * x2 <= 129)
    model.addConstr(4.69 * x1 + 5.92 * x2 + 4.45 * x3 <= 152)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
