
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="chicken thighs")
x1 = m.addVar(vtype=GRB.INTEGER, name="chicken breasts")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hot dogs")
x3 = m.addVar(vtype=GRB.INTEGER, name="blueberry pies")


# Set objective function
m.setObjective(6*x0*x1 + 7*x0*x3 + 3*x2*x2 + 5*x2*x3 + 9*x0 + 1*x1 + 5*x2 + 3*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 5*x2 >= 8, "c1")
m.addConstr(5*x0 + 2*x1 >= 19, "c2")
m.addConstr(2*x1 + 9*x3 >= 18, "c3")
m.addConstr(2*x0*x0 + 8*x2*x2 >= 10, "c4")
m.addConstr(2*x1 + 9*x3 <= 54, "c5")
m.addConstr(5*x0*x0 + 5*x2*x2 <= 48, "c6")
m.addConstr(5*x2 + 9*x3 <= 47, "c7")
m.addConstr(5*x0 + 2*x1 + 5*x2 <= 45, "c8")
m.addConstr(5*x0 + 5*x2 + 9*x3 <= 49, "c9")
m.addConstr(5*x0 + 2*x1 + 5*x2 + 9*x3 <= 49, "c10")
m.addConstr(6*x1 + 4*x3 <= 24, "c11")
m.addConstr(1*x2*x2 + 4*x3*x3 <= 54, "c12")
m.addConstr(4*x0 + 6*x1 + 1*x2 + 4*x3 <= 54, "c13")
m.addConstr(2*x0 + 1*x3 <= 72, "c14")
m.addConstr(2*x0 + 8*x2 <= 21, "c15")
m.addConstr(5*x1 + 1*x3 <= 69, "c16")
m.addConstr(5*x1 + 8*x2 <= 70, "c17")
m.addConstr(2*x0 + 5*x1 + 8*x2 + 1*x3 <= 70, "c18")

m.addConstr(5*x0 + 2*x1 + 5*x2 + 9*x3 <= 84, "r0")
m.addConstr(4*x0 + 6*x1 + 1*x2 + 4*x3 <= 58, "r1")
m.addConstr(2*x0 + 5*x1 + 8*x2 + 1*x3 <= 79, "r2")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

