
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x0 = m.addVar(name="chicken_thighs", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="chicken_breasts", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="hot_dogs")
x3 = m.addVar(name="blueberry_pies", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(6*x0*x1 + 7*x0*x3 + 3*x2**2 + 5*x2*x3 + 9*x0 + x1 + 5*x2 + 3*x3, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(5*x0 + 2*x1 + 5*x2 + 9*x3 <= 84)
m.addConstr(4*x0 + 6*x1 + x2 + 4*x3 <= 58)
m.addConstr(2*x0 + 5*x1 + 8*x2 + x3 <= 79)
m.addConstr(5*x0 + 5*x2 >= 8)
m.addConstr(5*x0 + 2*x1 >= 19)
m.addConstr(2*x1 + 9*x3 >= 18)
m.addConstr(2*x0**2 + 8*x2**2 >= 10)
m.addConstr(2*x1 + 9*x3 <= 54)
m.addConstr(5*x0**2 + 5*x2**2 <= 48)
m.addConstr(5*x2 + 9*x3 <= 47)
m.addConstr(5*x0 + 2*x1 + 5*x2 <= 45)
m.addConstr(5*x0 + 5*x2 + 9*x3 <= 49)
m.addConstr(5*x0 + 2*x1 + 5*x2 + 9*x3 <= 49)
m.addConstr(6*x1 + 4*x3 <= 24)
m.addConstr(x2**2 + 4*x3**2 <= 54)
m.addConstr(4*x0 + 6*x1 + x2 + 4*x3 <= 54)
m.addConstr(2*x0 + x3 <= 72)
m.addConstr(2*x0 + 8*x2 <= 21)
m.addConstr(5*x1 + x3 <= 69)
m.addConstr(5*x1 + 8*x2 <= 70)
m.addConstr(2*x0 + 5*x1 + 8*x2 + x3 <= 70)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Chicken thighs: ", x0.varValue)
    print("Chicken breasts: ", x1.varValue)
    print("Hot dogs: ", x2.varValue)
    print("Blueberry pies: ", x3.varValue)
else:
    print("The model is infeasible")
