
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimize_work_hours")

    # Create variables
    john_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="john_hours")
    dale_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="dale_hours")
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")

    # Set objective function
    model.setObjective(6.38 * john_hours + 8.77 * dale_hours + 2.38 * laura_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7 * john_hours + 6 * dale_hours >= 49)
    model.addConstr(7 * john_hours + 2 * laura_hours >= 45)
    model.addConstr(6 * dale_hours + 2 * laura_hours >= 39)
    model.addConstr(5 * dale_hours + 11 * laura_hours >= 27)
    model.addConstr(14 * john_hours + 11 * laura_hours >= 22)
    model.addConstr(2 * john_hours + 9 * laura_hours >= 24)
    model.addConstr(2 * john_hours + 7 * dale_hours >= 43)
    model.addConstr(7 * john_hours + 2 * laura_hours <= 143)
    model.addConstr(7 * john_hours + 6 * dale_hours <= 142)
    model.addConstr(7 * john_hours + 6 * dale_hours + 2 * laura_hours <= 232)
    model.addConstr(14 * john_hours + 5 * dale_hours <= 136)
    model.addConstr(14 * john_hours + 5 * dale_hours + 11 * laura_hours <= 136)
    model.addConstr(12 * john_hours + 7 * laura_hours <= 282)
    model.addConstr(12 * john_hours + 6 * dale_hours <= 252)
    model.addConstr(6 * dale_hours + 7 * laura_hours <= 156)
    model.addConstr(12 * john_hours + 6 * dale_hours + 7 * laura_hours <= 262)
    model.addConstr(7 * dale_hours + 9 * laura_hours <= 105)
    model.addConstr(2 * john_hours + 7 * dale_hours <= 119)
    model.addConstr(2 * john_hours + 7 * dale_hours + 9 * laura_hours <= 110)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('John Hours: %g' % john_hours.x)
        print('Dale Hours: %g' % dale_hours.x)
        print('Laura Hours: %g' % laura_hours.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
