
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by John
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Dale
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Laura

    # Objective function
    model.setObjective(6.38 * x0 + 8.77 * x1 + 2.38 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(7 * x0 + 6 * x1 >= 49)
    model.addConstr(7 * x0 + 2 * x2 >= 45)
    model.addConstr(6 * x1 + 2 * x2 >= 39)
    model.addConstr(5 * x1 + 11 * x2 >= 27)
    model.addConstr(14 * x0 + 11 * x2 >= 22)
    model.addConstr(2 * x0 + 9 * x2 >= 24)
    model.addConstr(2 * x0 + 7 * x1 >= 43)
    model.addConstr(7 * x0 + 6 * x1 <= 142)
    model.addConstr(7 * x0 + 2 * x2 <= 143)
    model.addConstr(7 * x0 + 6 * x1 + 2 * x2 <= 232)
    model.addConstr(14 * x0 + 5 * x1 + 11 * x2 <= 136)
    model.addConstr(12 * x0 + 7 * x2 <= 282)
    model.addConstr(12 * x0 + 6 * x1 <= 252)
    model.addConstr(6 * x1 + 7 * x2 <= 156)
    model.addConstr(12 * x0 + 6 * x1 + 7 * x2 <= 262)
    model.addConstr(7 * x1 + 9 * x2 <= 105)
    model.addConstr(2 * x0 + 7 * x1 <= 119)
    model.addConstr(2 * x0 + 7 * x1 + 9 * x2 <= 110)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by John: ", x0.varValue)
        print("Hours worked by Dale: ", x1.varValue)
        print("Hours worked by Laura: ", x2.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
