
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Computer_Competence_Optimization")

    # Create variables
    peggy_hours = model.addVar(lb=0, name="peggy_hours")  # Non-negative
    bill_hours = model.addVar(lb=0, name="bill_hours")  # Non-negative


    # Set objective function
    model.setObjective(3.66 * peggy_hours + 2.91 * bill_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.81 * peggy_hours + 21.75 * bill_hours >= 69, "computer_competence_min")
    model.addConstr(2 * peggy_hours - 3 * bill_hours >= 0, "hours_relation")
    model.addConstr(0.81 * peggy_hours + 21.75 * bill_hours <= 168, "computer_competence_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Peggy: {peggy_hours.x}")
        print(f"Hours worked by Bill: {bill_hours.x}")
        print(f"Objective Value: {model.objVal}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
