
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x1 = m.addVar(lb=0, name="hours_worked_by_Peggy")
x2 = m.addVar(lb=0, name="hours_worked_by_Bill")

# Set the objective function
m.setObjective(3.66*x1 + 2.91*x2, GRB.MAXIMIZE)

# Add constraints to the model
m.addConstr(0.81*x1 + 21.75*x2 >= 69, "combined_competence_rating_min")
m.addConstr(2*x1 - 3*x2 >= 0, "peggy_bill_hours_ratio")
m.addConstr(0.81*x1 + 21.75*x2 <= 168, "combined_competence_rating_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Peggy: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
