
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Peggy', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='hours_worked_by_Bill', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3.66 * x1 + 2.91 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.81 * x1 + 21.75 * x2 >= 69)
    model.addConstr(2 * x1 - 3 * x2 >= 0)
    model.addConstr(0.81 * x1 + 21.75 * x2 <= 168)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Peggy: {x1.x}')
        print(f'Hours worked by Bill: {x2.x}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
