
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
zinc = m.addVar(lb=0, name="zinc")
vitamin_a = m.addVar(lb=0, name="vitamin_a")
calcium = m.addVar(lb=0, name="calcium")
magnesium = m.addVar(lb=0, name="magnesium")

# Set objective function
m.setObjective(5*zinc + 7*vitamin_a + 3*calcium + 1*magnesium, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*vitamin_a + 7*magnesium >= 75)
m.addConstr(8*zinc + 11*vitamin_a >= 71)
m.addConstr(11*vitamin_a + 16*calcium >= 97)
m.addConstr(8*zinc + 11*vitamin_a + 16*calcium >= 101)
m.addConstr(11*vitamin_a + 16*calcium + 7*magnesium >= 101)
m.addConstr(8*zinc + 11*vitamin_a + 7*magnesium >= 101)
m.addConstr(8*zinc + 11*vitamin_a + 16*calcium >= 95)
m.addConstr(11*vitamin_a + 16*calcium + 7*magnesium >= 95)
m.addConstr(8*zinc + 11*vitamin_a + 7*magnesium >= 95)
m.addConstr(8*zinc + 11*vitamin_a + 16*calcium >= 78)
m.addConstr(11*vitamin_a + 16*calcium + 7*magnesium >= 78)
m.addConstr(8*zinc + 11*vitamin_a + 7*magnesium >= 78)
m.addConstr(8*zinc + 11*vitamin_a + 16*calcium + 7*magnesium >= 78)
m.addConstr(5*zinc + 3*magnesium >= 20)
m.addConstr(2*vitamin_a + 7*calcium >= 46)
m.addConstr(5*zinc + 2*vitamin_a + 7*calcium + 3*magnesium >= 46)
m.addConstr(19*zinc + 12*magnesium >= 20)
m.addConstr(19*zinc + 9*calcium >= 31)
m.addConstr(9*calcium + 12*magnesium >= 37)
m.addConstr(14*vitamin_a + 9*calcium + 12*magnesium >= 27)
m.addConstr(19*zinc + 14*vitamin_a + 9*calcium + 12*magnesium >= 27)
m.addConstr(8*zinc - 5*calcium >= 0)
m.addConstr(-1*zinc + 3*magnesium >= 0)
m.addConstr(11*vitamin_a + 16*calcium <= 347)
m.addConstr(8*zinc + 11*vitamin_a + 16*calcium <= 205)
m.addConstr(8*zinc + 16*calcium + 7*magnesium <= 425)
m.addConstr(8*zinc + 11*vitamin_a + 7*magnesium <= 418)
m.addConstr(2*vitamin_a + 7*calcium <= 117)
m.addConstr(5*zinc + 3*magnesium <= 71)
m.addConstr(19*zinc + 9*calcium <= 159)
m.addConstr(9*calcium + 12*magnesium <= 127)
m.addConstr(19*zinc + 14*vitamin_a + 12*magnesium <= 165)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

