
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="milligrams_of_zinc", lb=-gp.GRB.INFINITY)
x1 = m.addVar(name="milligrams_of_vitamin_A", lb=-gp.GRB.INFINITY)
x2 = m.addVar(name="milligrams_of_calcium", lb=-gp.GRB.INFINITY)
x3 = m.addVar(name="milligrams_of_magnesium", lb=-gp.GRB.INFINITY)

# Define the objective function
m.setObjective(5 * x0 + 7 * x1 + 3 * x2 + x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * x0 >= 0)
m.addConstr(5 * x0 >= 0)
m.addConstr(19 * x0 >= 0)
m.addConstr(11 * x1 >= 0)
m.addConstr(2 * x1 >= 0)
m.addConstr(14 * x1 >= 0)
m.addConstr(16 * x2 >= 0)
m.addConstr(7 * x2 >= 0)
m.addConstr(9 * x2 >= 0)
m.addConstr(7 * x3 >= 0)
m.addConstr(3 * x3 >= 0)
m.addConstr(12 * x3 >= 0)
m.addConstr(11 * x1 + 7 * x3 >= 75)
m.addConstr(8 * x0 + 11 * x1 >= 71)
m.addConstr(11 * x1 + 16 * x2 >= 97)
m.addConstr(8 * x0 + 11 * x1 + 16 * x2 >= 101)
m.addConstr(11 * x1 + 16 * x2 + 7 * x3 >= 101)
m.addConstr(8 * x0 + 11 * x1 + 7 * x3 >= 101)
m.addConstr(8 * x0 + 11 * x1 + 16 * x2 >= 95)
m.addConstr(11 * x1 + 16 * x2 + 7 * x3 >= 95)
m.addConstr(8 * x0 + 11 * x1 + 7 * x3 >= 95)
m.addConstr(8 * x0 + 11 * x1 + 16 * x2 >= 78)
m.addConstr(11 * x1 + 16 * x2 + 7 * x3 >= 78)
m.addConstr(8 * x0 + 11 * x1 + 7 * x3 >= 78)
m.addConstr(8 * x0 + 11 * x1 + 16 * x2 + 7 * x3 >= 78)
m.addConstr(5 * x0 + 3 * x3 >= 20)
m.addConstr(2 * x1 + 7 * x2 >= 46)
m.addConstr(5 * x0 + 2 * x1 + 7 * x2 + 3 * x3 >= 46)
m.addConstr(19 * x0 + 12 * x3 >= 20)
m.addConstr(19 * x0 + 9 * x2 >= 31)
m.addConstr(9 * x2 + 12 * x3 >= 37)
m.addConstr(14 * x1 + 9 * x2 + 12 * x3 >= 27)
m.addConstr(19 * x0 + 14 * x1 + 9 * x2 + 12 * x3 >= 27)
m.addConstr(8 * x0 - 5 * x2 >= 0)
m.addConstr(-x0 + 3 * x3 >= 0)
m.addConstr(11 * x1 + 16 * x2 <= 347)
m.addConstr(8 * x0 + 11 * x1 + 16 * x2 <= 205)
m.addConstr(8 * x0 + 16 * x2 + 7 * x3 <= 425)
m.addConstr(8 * x0 + 11 * x1 + 7 * x3 <= 418)
m.addConstr(2 * x1 + 7 * x2 <= 117)
m.addConstr(5 * x0 + 3 * x3 <= 71)
m.addConstr(19 * x0 + 9 * x2 <= 159)
m.addConstr(9 * x2 + 12 * x3 <= 127)
m.addConstr(19 * x0 + 14 * x1 + 12 * x3 <= 165)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("milligrams of zinc: ", x0.varValue)
    print("milligrams of vitamin A: ", x1.varValue)
    print("milligrams of calcium: ", x2.varValue)
    print("milligrams of magnesium: ", x3.varValue)
else:
    print("The model is infeasible")
