
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin E
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # milligrams of iron
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin A
    x3 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x3") # milligrams of vitamin B9


    # Set objective function
    m.setObjective(8*x0 + 4*x1 + 2*x2 + 9*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10.77*x0 + 0.37*x1 + 9.84*x2 + 11.4*x3 <= 275, "r0")
    m.addConstr(11.54*x0 + 1.19*x1 + 9.85*x2 + 2.39*x3 <= 394, "r1")
    m.addConstr(8.5*x0 + 6.46*x1 + 6.74*x2 + 9.65*x3 <= 285, "r2")
    m.addConstr(0.37*x1 + 11.4*x3 >= 26, "c1")
    m.addConstr(10.77*x0 + 0.37*x1 >= 25, "c2")
    m.addConstr(10.77*x0 + 11.4*x3 >= 33, "c3")
    m.addConstr(10.77*x0 + 0.37*x1 + 9.84*x2 >= 36, "c4")
    m.addConstr(10.77*x0 + 0.37*x1 + 9.84*x2 + 11.4*x3 >= 36, "c5")
    m.addConstr(1.19*x1 + 2.39*x3 >= 92, "c6")
    m.addConstr(1.19*x1 + 9.85*x2 >= 39, "c7")
    m.addConstr(11.54*x0 + 9.85*x2 >= 56, "c8")
    m.addConstr(11.54*x0 + 1.19*x1 + 9.85*x2 + 2.39*x3 >= 56, "c9")
    m.addConstr(6.46*x1 + 6.74*x2 >= 50, "c10")
    m.addConstr(8.5*x0 + 6.74*x2 >= 43, "c11")
    m.addConstr(6.46*x1 + 9.65*x3 >= 65, "c12")
    m.addConstr(8.5*x0 + 6.46*x1 + 6.74*x2 + 9.65*x3 >= 65, "c13")
    m.addConstr(10*x1 - x3 >= 0, "c14")
    m.addConstr(2*x2 - 9*x3 >= 0, "c15")
    m.addConstr(6.46*x1 + 6.74*x2 <= 215, "c16")
    m.addConstr(6.74*x2 + 9.65*x3 <= 80, "c17")
    m.addConstr(6.46*x1 + 9.65*x3 <= 282, "c18")
    m.addConstr(8.5*x0 + 6.46*x1 <= 178, "c19")
    m.addConstr(8.5*x0 + 9.65*x3 <= 223, "c20")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
