
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of vitamin E
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="x2")  # milligrams of iron
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin A
    x4 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, type=gurobi.GRB.INTEGER, name="x4")  # milligrams of vitamin B9

    # Objective function
    model.setObjective(8 * x1 + 4 * x2 + 2 * x3 + 9 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(0.37 * x2 + 11.4 * x4 >= 26)
    model.addConstr(10.77 * x1 + 0.37 * x2 >= 25)
    model.addConstr(10.77 * x1 + 11.4 * x4 >= 33)
    model.addConstr(10.77 * x1 + 0.37 * x2 + 9.84 * x3 >= 36)
    model.addConstr(10.77 * x1 + 0.37 * x2 + 9.84 * x3 + 11.4 * x4 >= 36)
    model.addConstr(1.19 * x2 + 2.39 * x4 >= 92)
    model.addConstr(1.19 * x2 + 9.85 * x3 >= 39)
    model.addConstr(11.54 * x1 + 9.85 * x3 >= 56)
    model.addConstr(11.54 * x1 + 1.19 * x2 + 9.85 * x3 + 2.39 * x4 >= 56)
    model.addConstr(6.46 * x2 + 6.74 * x3 >= 50)
    model.addConstr(8.5 * x1 + 6.74 * x3 >= 43)
    model.addConstr(6.46 * x2 + 9.65 * x4 >= 65)
    model.addConstr(8.5 * x1 + 6.46 * x2 + 6.74 * x3 + 9.65 * x4 >= 65)
    model.addConstr(10 * x2 - x4 >= 0)
    model.addConstr(2 * x3 - 9 * x4 >= 0)
    model.addConstr(6.46 * x2 + 6.74 * x3 <= 215)
    model.addConstr(6.74 * x3 + 9.65 * x4 <= 80)
    model.addConstr(6.46 * x2 + 9.65 * x4 <= 282)
    model.addConstr(8.5 * x1 + 6.46 * x2 <= 178)
    model.addConstr(8.5 * x1 + 9.65 * x4 <= 223)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
