
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="bottles of ibuprofen")
x1 = m.addVar(vtype=GRB.INTEGER, name="dish soap bottles")
x2 = m.addVar(vtype=GRB.INTEGER, name="paper towel rolls")
x3 = m.addVar(vtype=GRB.INTEGER, name="cookies")
x4 = m.addVar(vtype=GRB.INTEGER, name="packs of paper plates")
x5 = m.addVar(vtype=GRB.INTEGER, name="lightbulbs")
x6 = m.addVar(vtype=GRB.INTEGER, name="diapers")


# Set objective function
m.setObjective(3*x0**2 + 9*x0*x1 + 9*x0*x4 + 5*x0*x5 + 9*x1**2 + 8*x1*x3 + 5*x1*x4 + 6*x1*x5 + 7*x1*x6 + 9*x2*x3 + 9*x2*x4 + 7*x2*x5 + 6*x3*x4 + 4*x3*x5 + 5*x3*x6 + 7*x4*x5 + 5*x4*x6 + 2*x5**2 + 7*x6**2 + 7*x0 + 8*x1 + 8*x2 + 3*x4, GRB.MAXIMIZE)

# Add constraints
m.addConstr(5*x0 + 3*x1 + 1*x2 + 1*x3 + 4*x4 + 5*x5 + 3*x6 <= 170)
m.addConstr(3*x1**2 + 1*x3**2 >= 21)
m.addConstr(5*x0 + 5*x5 >= 18)
m.addConstr(4*x4 + 5*x5 >= 16)
m.addConstr(5*x0**2 + 1*x2**2 >= 16)
m.addConstr(5*x0 + 1*x3 >= 19)
m.addConstr(3*x1**2 + 1*x2**2 >= 20)
m.addConstr(1*x2**2 + 5*x5**2 >= 22)
m.addConstr(1*x3**2 + 4*x4**2 >= 19)
m.addConstr(1*x3 + 3*x6 >= 23)
m.addConstr(4*x4 + 3*x6 >= 18)
m.addConstr(3*x1 + 3*x6 >= 23)
m.addConstr(5*x0 + 4*x4 >= 22)
m.addConstr(5*x5 + 3*x6 >= 8)
m.addConstr(1*x2 + 1*x3 >= 24)
m.addConstr(1*x2 + 3*x6 >= 22)
m.addConstr(5*x0**2 + 3*x1**2 >= 18)
m.addConstr(3*x1 + 4*x4 >= 17)
m.addConstr(1*x3 + 5*x5 >= 18)
m.addConstr(3*x1**2 + 1*x2**2 + 3*x6**2 >= 13)
m.addConstr(3*x1 + 1*x2 + 5*x5 >= 13)
m.addConstr(3*x1**2 + 1*x3**2 + 5*x5**2 >= 13)
m.addConstr(1*x2 + 4*x4 + 5*x5 >= 13)
m.addConstr(3*x1 + 1*x2 + 3*x6 >= 21)
m.addConstr(3*x1**2 + 1*x2**2 + 5*x5**2 >= 21)
m.addConstr(3*x1**2 + 1*x3**2 + 5*x5**2 >= 21)
m.addConstr(1*x2**2 + 4*x4**2 + 5*x5**2 >= 21)
m.addConstr(3*x1 + 1*x2 + 3*x6 >= 18)
m.addConstr(3*x1 + 1*x2 + 5*x5 >= 18)
m.addConstr(3*x1 + 1*x3 + 5*x5 >= 18)
m.addConstr(1*x2**2 + 4*x4**2 + 5*x5**2 >= 18)
m.addConstr(3*x1**2 + 1*x2**2 + 3*x6**2 >= 13)
m.addConstr(3*x1**2 + 1*x2**2 + 5*x5**2 >= 13)
m.addConstr(3*x1 + 1*x3 + 5*x5 >= 13)
m.addConstr(1*x2**2 + 4*x4**2 + 5*x5**2 >= 13)
m.addConstr(5*x0 + 1*x3 <= 95)
m.addConstr(3*x1**2 + 1*x3**2 <= 127)
m.addConstr(3*x1**2 + 4*x4**2 <= 139)
m.addConstr(5*x0**2 + 1*x2**2 + 1*x3**2 <= 123)
m.addConstr(1*x2**2 + 4*x4**2 + 3*x6**2 <= 80)
m.addConstr(1*x2 + 1*x3 + 5*x5 <= 50)
m.addConstr(5*x0 + 5*x5 + 3*x6 <= 64)
m.addConstr(1*x2**2 + 1*x3**2 + 4*x4**2 <= 35)
m.addConstr(5*x0**2 + 1*x3**2 + 3*x6**2 <= 108)
m.addConstr(3*x1 + 1*x3 + 3*x6 <= 33)
m.addConstr(1*x3 + 4*x4 + 3*x6 <= 152)
m.addConstr(3*x1 + 1*x2 + 1*x3 <= 47)
m.addConstr(3*x1**2 + 1*x2**2 + 5*x5**2 <= 113)
m.addConstr(5*x0 + 3*x1 + 4*x4 <= 150)
m.addConstr(1*x2 + 5*x5 + 3*x6 <= 135)
m.addConstr(5*x0 + 4*x4 + 3*x6 <= 62)
m.addConstr(3*x1 + 1*x3 + 5*x5 <= 33)
m.addConstr(3*x1 + 4*x4 + 5*x5 <= 83)
m.addConstr(5*x0 + 1*x2 + 5*x5 <= 98)
m.addConstr(5*x0 + 1*x2 + 4*x4 <= 75)
m.addConstr(3*x1**2 + 1*x2**2 + 4*x4**2 <= 154)
m.addConstr(1*x2**2 + 4*x4**2 + 5*x5**2 <= 109)
m.addConstr(3*x1 + 5*x5 + 3*x6 <= 73)
m.addConstr(1*x2 + 1*x3 + 3*x6 <= 156)
m.addConstr(4*x4 + 5*x5 + 3*x6 <= 96)
m.addConstr(5*x0**2 + 3*x1**2 + 5*x5**2 <= 51)
m.addConstr(5*x0 + 1*x3 + 4*x4 <= 129)
m.addConstr(5*x0 + 1*x3 + 5*x5 <= 39)
m.addConstr(5*x0 + 3*x1 + 1*x2 + 1*x3 + 4*x4 + 5*x5 + 3*x6 <= 39)


# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print(f'{v.varName}: {v.x}')
    print(f'Obj: {m.objVal}')
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

