
import gurobipy as gp

# Create a new model
m = gp.Model("minimize_labor_cost")

# Create variables
hank_hours = m.addVar(lb=0, name="hank_hours")
bill_hours = m.addVar(lb=0, name="bill_hours")
mary_hours = m.addVar(lb=0, name="mary_hours")


# Set objective function
m.setObjective(2 * hank_hours + 1 * bill_hours + 2 * mary_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.15 * hank_hours + 7.36 * bill_hours >= 47, "cost_hank_bill")
m.addConstr(1.15 * hank_hours + 7.36 * bill_hours + 0.98 * mary_hours >= 41, "total_cost")
m.addConstr(-1 * hank_hours + 4 * mary_hours >= 0, "hank_mary_relation")
m.addConstr(1.15 * hank_hours + 0.98 * mary_hours <= 140, "cost_hank_mary")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {hank_hours.x}")
    print(f"Hours worked by Bill: {bill_hours.x}")
    print(f"Hours worked by Mary: {mary_hours.x}")
    print(f"Objective value: {m.objVal}")

