
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bill")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Define the objective function
m.setObjective(2*x1 + x2 + 2*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(1.15*x1 + 7.36*x2 >= 47, "constraint_1")
m.addConstr(1.15*x1 + 7.36*x2 + 0.98*x3 >= 41, "constraint_2")
m.addConstr(-x1 + 4*x3 >= 0, "constraint_3")
m.addConstr(1.15*x1 + 0.98*x3 <= 140, "constraint_4")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Hank: {x1.x}")
    print(f"Hours worked by Bill: {x2.x}")
    print(f"Hours worked by Mary: {x3.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
