
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Bill
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Mary

    # Define the objective function
    model.setObjective(2*x1 + x2 + 2*x3, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(1.15*x1 + 7.36*x2 >= 47)
    model.addConstr(1.15*x1 + 7.36*x2 + 0.98*x3 >= 41)
    model.addConstr(-x1 + 4*x3 >= 0)
    model.addConstr(1.15*x1 + 0.98*x3 <= 140)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Hours worked by Bill: {x2.varValue}")
        print(f"Hours worked by Mary: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
