
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
laura_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="laura_hours")
john_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="john_hours")
paul_hours = m.addVar(lb=0, vtype=GRB.INTEGER, name="paul_hours")
hank_hours = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hank_hours")


# Set objective function
m.setObjective(7.27*laura_hours**2 + 2.53*laura_hours*paul_hours + 9.86*laura_hours*hank_hours + 7.41*john_hours*hank_hours + 6.01*paul_hours**2 + 5.57*paul_hours*hank_hours + 6.29*hank_hours**2 + 5.81*laura_hours + 9.66*john_hours + 9.75*paul_hours, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*laura_hours**2 + 11*hank_hours**2 >= 54)
m.addConstr(11*laura_hours + 6*paul_hours >= 52)
m.addConstr(8*john_hours**2 + 6*paul_hours**2 >= 53)
m.addConstr(8*john_hours + 11*hank_hours >= 40)
m.addConstr(11*laura_hours + 8*john_hours + 6*paul_hours + 11*hank_hours >= 40)
m.addConstr(9*laura_hours + 19*john_hours >= 47)
m.addConstr(18*paul_hours + 5*hank_hours >= 56)
m.addConstr(9*laura_hours + 19*john_hours + 18*paul_hours + 5*hank_hours >= 56)
m.addConstr(12*john_hours + 13*hank_hours >= 55)
m.addConstr(12*laura_hours**2 + 12*john_hours**2 >= 48)
m.addConstr(12*laura_hours + 12*john_hours + 6*paul_hours + 13*hank_hours >= 48)
m.addConstr(6*laura_hours**2 - 9*john_hours**2 >= 0)
m.addConstr(11*laura_hours + 6*paul_hours + 11*hank_hours <= 161)
m.addConstr(11*laura_hours + 8*john_hours + 6*paul_hours <= 197)
m.addConstr(19*john_hours + 18*paul_hours <= 250)
m.addConstr(18*paul_hours**2 + 5*hank_hours**2 <= 112)
m.addConstr(19*john_hours + 18*paul_hours + 5*hank_hours <= 102)
m.addConstr(9*laura_hours**2 + 19*john_hours**2 + 18*paul_hours**2 <= 144)
m.addConstr(12*john_hours + 6*paul_hours <= 152)
m.addConstr(12*laura_hours + 12*john_hours + 6*paul_hours <= 215)
m.addConstr(12*laura_hours + 12*john_hours + 13*hank_hours <= 180)
m.addConstr(12*john_hours**2 + 6*paul_hours**2 + 13*hank_hours**2 <= 220)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

