
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=0, name="hours_worked_by_Laura", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="hours_worked_by_John", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=0, name="hours_worked_by_Paul", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(lb=0, name="hours_worked_by_Hank", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(7.27*x0**2 + 2.53*x0*x2 + 9.86*x0*x3 + 7.41*x1*x3 + 6.01*x2**2 + 5.57*x2*x3 + 6.29*x3**2 + 5.81*x0 + 9.66*x1 + 9.75*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(11*x0 <= 231)
    model.addConstr(9*x0 <= 264)
    model.addConstr(12*x0 <= 239)
    model.addConstr(8*x1 <= 231)
    model.addConstr(19*x1 <= 264)
    model.addConstr(12*x1 <= 239)
    model.addConstr(6*x2 <= 231)
    model.addConstr(18*x2 <= 264)
    model.addConstr(6*x2 <= 239)
    model.addConstr(11*x3 <= 231)
    model.addConstr(5*x3 <= 264)
    model.addConstr(13*x3 <= 239)
    model.addConstr(11*x0**2 + 11*x3**2 >= 54)
    model.addConstr(11*x0 + 6*x2 >= 52)
    model.addConstr(8*x1**2 + 6*x2**2 >= 53)
    model.addConstr(8*x1 + 11*x3 >= 40)
    model.addConstr(11*x0 + 8*x1 + 6*x2 + 11*x3 >= 40)
    model.addConstr(9*x0 + 19*x1 >= 47)
    model.addConstr(18*x2 + 5*x3 >= 56)
    model.addConstr(9*x0 + 19*x1 + 18*x2 + 5*x3 >= 56)
    model.addConstr(12*x1 + 13*x3 >= 55)
    model.addConstr(12*x0**2 + 12*x1**2 >= 48)
    model.addConstr(12*x0 + 12*x1 + 6*x2 + 13*x3 >= 48)
    model.addConstr(6*x0**2 - 9*x1**2 >= 0)
    model.addConstr(11*x0 + 6*x2 + 11*x3 <= 161)
    model.addConstr(11*x0 + 8*x1 + 6*x2 <= 197)
    model.addConstr(19*x1 + 18*x2 <= 250)
    model.addConstr(18*x2**2 + 5*x3**2 <= 112)
    model.addConstr(19*x1 + 18*x2 + 5*x3 <= 102)
    model.addConstr(9*x0**2 + 19*x1**2 + 18*x2**2 <= 144)
    model.addConstr(12*x1 + 6*x2 <= 152)
    model.addConstr(12*x0 + 12*x1 + 6*x2 <= 215)
    model.addConstr(12*x0 + 12*x1 + 13*x3 <= 180)
    model.addConstr(12*x1**2 + 6*x2**2 + 13*x3**2 <= 220)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Hours worked by Laura: ", x0.varValue)
        print("Hours worked by John: ", x1.varValue)
        print("Hours worked by Paul: ", x2.varValue)
        print("Hours worked by Hank: ", x3.varValue)
    else:
        print("No optimal solution found.")

optimization_problem()
