
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_B2")  # Integer
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_D") # Continuous
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium") # Continuous


    # Set objective function
    m.setObjective(1*x0 + 3*x1 + 6*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(1*x0 + 3*x1 >= 20, "c0")
    m.addConstr(1*x0 + 3*x1 + 13*x2 >= 20, "c1")
    m.addConstr(14*x0 + 1*x2 >= 19, "c2")
    m.addConstr(14*x0 + 4*x1 >= 16, "c3")
    m.addConstr(14*x0 + 4*x1 + 1*x2 >= 12, "c4")
    m.addConstr(12*x0 + 1*x2 >= 24, "c5")
    m.addConstr(12*x0 + 6*x1 >= 10, "c6")
    m.addConstr(12*x0 + 6*x1 + 9*x2 >= 10, "c7")
    m.addConstr(-9*x1 + 6*x2 >= 0, "c8")
    m.addConstr(4*x1 + 1*x2 <= 47, "c9")
    m.addConstr(12*x0 + 6*x1 <= 69, "c10")
    m.addConstr(6*x1 + 9*x2 <= 40, "c11")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
