
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B2
    x2 = model.addVar(name="x2")  # milligrams of vitamin D
    x3 = model.addVar(name="x3")  # milligrams of magnesium

    # Objective function
    model.setObjective(1*x1 + 3*x2 + 6*x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 == 1)
    model.addConstr(14*x1 == 14)
    model.addConstr(12*x1 == 12)
    model.addConstr(3*x2 == 3)
    model.addConstr(4*x2 == 4)
    model.addConstr(6*x2 == 6)
    model.addConstr(13*x3 == 13)
    model.addConstr(x3 == 1)
    model.addConstr(9*x3 == 9)
    model.addConstr(x1 + 3*x2 >= 20)
    model.addConstr(x1 + 3*x2 + 13*x3 >= 20)
    model.addConstr(14*x1 + x3 >= 19)
    model.addConstr(14*x1 + 4*x2 >= 16)
    model.addConstr(14*x1 + 4*x2 + x3 >= 12)
    model.addConstr(14*x1 + x3 >= 24)
    model.addConstr(14*x1 + 6*x2 >= 10)
    model.addConstr(14*x1 + 6*x2 + 9*x3 >= 10)
    model.addConstr(-9*x2 + 6*x3 >= 0)
    model.addConstr(4*x2 + x3 <= 47)
    model.addConstr(14*x1 + 6*x2 <= 69)
    model.addConstr(6*x2 + 9*x3 <= 40)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
