
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
protein = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="protein")
magnesium = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="magnesium")
vitamin_b5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b5")
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat")
fiber = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fiber")


# Set objective function
m.setObjective(2*protein + 6*magnesium + 3*vitamin_b5 + 2*fat + 8*fiber, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*protein + 17*magnesium >= 24)
m.addConstr(11*vitamin_b5 + 7*fiber >= 38)
m.addConstr(17*magnesium + 7*fiber >= 47)
m.addConstr(12*fat + 7*fiber >= 38)
m.addConstr(11*vitamin_b5 + 12*fat >= 36)
m.addConstr(17*protein + 12*fat >= 36)
m.addConstr(17*magnesium + 11*vitamin_b5 >= 21)
m.addConstr(17*magnesium + 11*vitamin_b5 + 7*fiber >= 48)
m.addConstr(17*protein + 11*vitamin_b5 + 12*fat >= 48)
m.addConstr(17*magnesium + 11*vitamin_b5 + 7*fiber >= 48)
m.addConstr(17*protein + 11*vitamin_b5 + 12*fat >= 48)
m.addConstr(15*protein + 7*fat >= 48)
m.addConstr(7*magnesium + 5*vitamin_b5 >= 23)
m.addConstr(15*protein + 7*magnesium >= 27)
m.addConstr(15*protein + 16*fiber >= 60)
m.addConstr(7*magnesium + 16*fiber >= 50)
m.addConstr(5*vitamin_b5 + 7*fat >= 57)
m.addConstr(5*vitamin_b5 + 16*fiber >= 43)
m.addConstr(5*vitamin_b5 + 7*fat + 16*fiber >= 58)
m.addConstr(7*magnesium + 5*vitamin_b5 + 16*fiber >= 58)
m.addConstr(5*vitamin_b5 + 7*fat + 16*fiber >= 36)
m.addConstr(7*magnesium + 5*vitamin_b5 + 16*fiber >= 36)
m.addConstr(15*protein + 8*magnesium >= 45)
m.addConstr(15*protein + 11*vitamin_b5 >= 80)
m.addConstr(8*magnesium + 4*fat >= 30)
m.addConstr(17*protein + 11*vitamin_b5 <= 130)
m.addConstr(17*magnesium + 12*fat <= 193)
m.addConstr(17*protein + 17*magnesium <= 202)
m.addConstr(17*protein + 7*fiber <= 254)
m.addConstr(17*protein + 17*magnesium + 11*vitamin_b5 <= 264)
m.addConstr(17*protein + 17*magnesium + 7*fiber <= 133)
m.addConstr(11*vitamin_b5 + 12*fat + 7*fiber <= 109)
m.addConstr(17*protein + 17*magnesium + 12*fat <= 187)
m.addConstr(17*protein + 17*magnesium + 11*vitamin_b5 + 12*fat + 7*fiber <= 187)
m.addConstr(15*protein + 7*fat <= 66)
m.addConstr(7*fat + 16*fiber <= 180)
m.addConstr(7*magnesium + 7*fat <= 230)
m.addConstr(15*protein + 5*vitamin_b5 <= 234)
m.addConstr(7*magnesium + 16*fiber <= 260)
m.addConstr(5*vitamin_b5 + 16*fiber <= 301)
m.addConstr(7*magnesium + 5*vitamin_b5 <= 89)
m.addConstr(7*magnesium + 7*fat + 16*fiber <= 263)
m.addConstr(15*protein + 7*fat + 16*fiber <= 274)
m.addConstr(15*protein + 7*magnesium + 16*fiber <= 108)
m.addConstr(15*protein + 5*vitamin_b5 + 7*fat <= 147)
m.addConstr(15*protein + 5*vitamin_b5 + 16*fiber <= 109)
m.addConstr(15*protein + 7*magnesium + 5*vitamin_b5 + 7*fat + 16*fiber <= 109)
m.addConstr(8*magnesium + 11*vitamin_b5 <= 242)
m.addConstr(15*protein + 11*vitamin_b5 <= 373)
m.addConstr(8*magnesium + 4*fat <= 343)
m.addConstr(4*fat + 12*fiber <= 127)
m.addConstr(15*protein + 4*fat <= 308)
m.addConstr(8*magnesium + 12*fiber <= 332)
m.addConstr(15*protein + 8*magnesium <= 187)
m.addConstr(15*protein + 8*magnesium + 12*fiber <= 321)
m.addConstr(15*protein + 8*magnesium + 11*vitamin_b5 + 4*fat + 12*fiber <= 321)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

