
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hot_dogs")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls_of_cereal")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
x4 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="ham_sandwiches")


# Set objective function
m.setObjective(8.85*x0**2 + 3.16*x0*x1 + 5.35*x0*x2 + 3.6*x0*x3 + 4.1*x0*x4 + 5.18*x1**2 + 3.79*x1*x2 + 9.68*x1*x3 + 5.14*x1*x4 + 5.98*x2**2 + 1.65*x2*x3 + 1.24*x2*x4 + 6.41*x3**2 + 9.39*x3*x4 + 7.18*x4**2 + 7.88*x0 + 6.53*x1 + 2.05*x2 + 6.31*x3 + 1.62*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x2 + 7*x4 >= 7)
m.addConstr(2*x1 + 1*x3 >= 10)
m.addConstr(11*x0 + 2*x1 >= 19)
m.addConstr(11*x0 + 7*x4 >= 18)
m.addConstr(11*x0 + 2*x1 + 10*x2 >= 12)
m.addConstr(11*x0**2 + 10*x2**2 + 7*x4**2 >= 12)
m.addConstr(2*x1 + 1*x3 + 7*x4 >= 12)
m.addConstr(2*x1 + 10*x2 + 7*x4 >= 12)
m.addConstr(11*x0 + 2*x1 + 7*x4 >= 12)
m.addConstr(11*x0 + 2*x1 + 10*x2 >= 16)
m.addConstr(11*x0 + 10*x2 + 7*x4 >= 16)
m.addConstr(2*x1 + 1*x3 + 7*x4 >= 16)
m.addConstr(2*x1 + 10*x2 + 7*x4 >= 16)
m.addConstr(11*x0**2 + 2*x1**2 + 7*x4**2 >= 16)
m.addConstr(11*x0 + 2*x1 + 10*x2 >= 17)
m.addConstr(11*x0**2 + 10*x2**2 + 7*x4**2 >= 17)
m.addConstr(2*x1 + 1*x3 + 7*x4 >= 17)
m.addConstr(2*x1**2 + 10*x2**2 + 7*x4**2 >= 17)
m.addConstr(11*x0**2 + 2*x1**2 + 7*x4**2 >= 17)
m.addConstr(11*x0 + 2*x1 + 10*x2 >= 15)
m.addConstr(11*x0 + 10*x2 + 7*x4 >= 15)
m.addConstr(2*x1**2 + 1*x3**2 + 7*x4**2 >= 15)
m.addConstr(2*x1 + 10*x2 + 7*x4 >= 15)
m.addConstr(11*x0 + 2*x1 + 7*x4 >= 15)
m.addConstr(11*x0 + 2*x1 + 10*x2 >= 16)
m.addConstr(11*x0 + 10*x2 + 7*x4 >= 16)
m.addConstr(2*x1 + 1*x3 + 7*x4 >= 16)
m.addConstr(2*x1 + 10*x2 + 7*x4 >= 16)
m.addConstr(11*x0 + 2*x1 + 7*x4 >= 16)
m.addConstr(10*x2 + 1*x3 <= 45)
m.addConstr(11*x0 + 7*x4 <= 51)
m.addConstr(2*x1 + 1*x3 <= 74)
m.addConstr(11*x0**2 + 1*x3**2 <= 94)
m.addConstr(11*x0**2 + 10*x2**2 <= 32)
m.addConstr(1*x3 + 7*x4 <= 86)
m.addConstr(2*x1**2 + 10*x2**2 <= 96)
m.addConstr(2*x1**2 + 7*x4**2 <= 24)
m.addConstr(11*x0 + 2*x1 + 10*x2 + 1*x3 + 7*x4 <= 24)
m.addConstr(11*x0 + 2*x1 + 10*x2 + x3 + 7*x4 <= 100)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

