
import gurobi as gp

# Define variables
x1 = gp.Var(name="rotisserie_chickens", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x2 = gp.Var(name="hot_dogs", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)
x3 = gp.Var(name="bowls_of_cereal", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x4 = gp.Var(name="potatoes", lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY)
x5 = gp.Var(name="ham_sandwiches", lb=0, ub=gp.GRB.INFINITY, vtype=gp.GRB.INTEGER)

# Create model
m = gp.Model()

# Objective function
m.setObjective(8.85*x1**2 + 3.16*x1*x2 + 5.35*x1*x3 + 3.6*x1*x4 + 4.1*x1*x5 + 
               5.18*x2**2 + 3.79*x2*x3 + 9.68*x2*x4 + 5.14*x2*x5 + 5.98*x3**2 + 
               1.65*x3*x4 + 1.24*x3*x5 + 6.41*x4**2 + 9.39*x4*x5 + 7.18*x5**2 + 
               7.88*x1 + 6.53*x2 + 2.05*x3 + 6.31*x4 + 1.62*x5, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(11*x1 + 2*x2 + 10*x3 + x4 + 7*x5 <= 100)
m.addConstr(10*x3 + 7*x5 >= 7)
m.addConstr(2*x2 + x4 >= 10)
m.addConstr(11*x1 + 2*x2 >= 19)
m.addConstr(11*x1 + 7*x5 >= 18)
m.addConstr(11*x1 + 2*x2 + 10*x3 >= 12)
m.addConstr(11**2*x1**2 + 10**2*x3**2 + 7**2*x5**2 >= 12)
m.addConstr(2*x2 + x4 + 7*x5 >= 12)
m.addConstr(2*x2 + 10*x3 + 7*x5 >= 12)
m.addConstr(11*x1 + 2*x2 + 7*x5 >= 12)
m.addConstr(11*x1 + 2*x2 + 10*x3 >= 16)
m.addConstr(11*x1 + 10*x3 + 7*x5 >= 16)
m.addConstr(2*x2 + x4 + 7*x5 >= 16)
m.addConstr(2*x2 + 10*x3 + 7*x5 >= 16)
m.addConstr(11**2*x1**2 + 2**2*x2**2 + 7**2*x5**2 >= 16)
m.addConstr(11*x1 + 2*x2 + 10*x3 >= 17)
m.addConstr(11**2*x1**2 + 10**2*x3**2 + 7**2*x5**2 >= 17)
m.addConstr(2*x2 + x4 + 7*x5 >= 17)
m.addConstr(2**2*x2**2 + 10**2*x3**2 + 7**2*x5**2 >= 17)
m.addConstr(11**2*x1**2 + 2**2*x2**2 + 7**2*x5**2 >= 17)
m.addConstr(11*x1 + 2*x2 + 10*x3 >= 15)
m.addConstr(11*x1 + 10*x3 + 7*x5 >= 15)
m.addConstr(2**2*x2**2 + x4**2 + 7**2*x5**2 >= 15)
m.addConstr(2*x2 + 10*x3 + 7*x5 >= 15)
m.addConstr(11*x1 + 2*x2 + 7*x5 >= 15)
m.addConstr(11*x1 + 2*x2 + 10*x3 >= 16)
m.addConstr(11*x1 + 10*x3 + 7*x5 >= 16)
m.addConstr(2*x2 + x4 + 7*x5 >= 16)
m.addConstr(2*x2 + 10*x3 + 7*x5 >= 16)
m.addConstr(11*x1 + 2*x2 + 7*x5 >= 16)
m.addConstr(10*x3 + x4 <= 45)
m.addConstr(11*x1 + 7*x5 <= 51)
m.addConstr(2*x2 + x4 <= 74)
m.addConstr(11**2*x1**2 + x4**2 <= 94)
m.addConstr(11**2*x1**2 + 10**2*x3**2 <= 32)
m.addConstr(x4 + 7*x5 <= 86)
m.addConstr(2**2*x2**2 + 10**2*x3**2 <= 96)
m.addConstr(2**2*x2**2 + 7**2*x5**2 <= 24)
m.addConstr(11*x1 + 2*x2 + 10*x3 + x4 + 7*x5 <= 24)

# Solve model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No solution found")
