
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
    calcium = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="calcium")
    vitamin_b2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
    vitamin_e = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_e")

    # Set objective function
    m.setObjective(9 * vitamin_b7 + 6 * calcium + 9 * vitamin_b2 + 6 * vitamin_e, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(8 * vitamin_b7 + 3 * calcium + 4 * vitamin_b2 + 4 * vitamin_e <= 85, "r0")
    m.addConstr(8 * vitamin_b7 + 4 * vitamin_e >= 14, "c1")
    m.addConstr(3 * calcium + 4 * vitamin_b2 + 4 * vitamin_e >= 12, "c2")
    m.addConstr(3 * calcium + 4 * vitamin_b2 <= 22, "c3")
    m.addConstr(8 * vitamin_b7 + 4 * vitamin_e <= 72, "c4")
    m.addConstr(8 * vitamin_b7 + 4 * vitamin_b2 <= 80, "c5")
    m.addConstr(8 * vitamin_b7 + 4 * vitamin_b2 + 4 * vitamin_e <= 85, "c6")
    m.addConstr(8 * vitamin_b7 + 3 * calcium + 4 * vitamin_e <= 36, "c7")
    m.addConstr(3 * calcium + 4 * vitamin_b2 + 4 * vitamin_e <= 45, "c8")
    m.addConstr(8 * vitamin_b7 + 3 * calcium + 4 * vitamin_b2 + 4 * vitamin_e <= 45, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
