
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="light_infantry_companies")
x1 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")

# Set objective function
m.setObjective(2*x0 + 2*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(0.37*x0 + 1.05*x1 >= 22, "logistics_footprint_lower")
m.addConstr(1.57*x0 + 1.74*x1 >= 22, "offensive_capability_lower")
m.addConstr(0.37*x0 + 1.05*x1 <= 35, "logistics_footprint_upper")
m.addConstr(1.57*x0 + 1.74*x1 <= 38, "offensive_capability_upper")
m.addConstr(8*x0 - 8*x1 >= 0, "difference_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Light Infantry Companies: {x0.x}")
    print(f"Water Purification Units: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
