
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="light_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(2*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(0.37*x1 + 1.05*x2 >= 22, name="min_logistics_footprint")
    model.addConstr(0.37*x1 + 1.05*x2 <= 65, name="max_logistics_footprint")
    model.addConstr(1.57*x1 + 1.74*x2 >= 22, name="min_offensive_capability")
    model.addConstr(1.57*x1 + 1.74*x2 <= 38, name="max_offensive_capability")
    model.addConstr(8*x1 - 8*x2 >= 0, name="relationship_between_variables")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Light infantry companies: {x1.varValue}")
        print(f"Water purification units: {x2.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
