
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition Optimization")

# Create variables
fiber = model.addVar(vtype=GRB.INTEGER, name="fiber")
vitamin_b1 = model.addVar(name="vitamin_b1")
vitamin_e = model.addVar(vtype=GRB.INTEGER, name="vitamin_e")
vitamin_b5 = model.addVar(name="vitamin_b5")
magnesium = model.addVar(vtype=GRB.INTEGER, name="magnesium")


# Set objective function
model.setObjective(4.32 * fiber + 3.11 * vitamin_b1 + 2.7 * vitamin_e + 4.92 * vitamin_b5 + 2.98 * magnesium, GRB.MAXIMIZE)

# Add constraints - Resource and additional constraints from the prompt
resources = {
    'r0': {'upper_bound': 113, 'coefficients': [2, 4, 10, 1, 14]},
    'r1': {'upper_bound': 116, 'coefficients': [8, 10, 11, 8, 10]},
    'r2': {'upper_bound': 165, 'coefficients': [13, 7, 7, 10, 8]}
}

for r, data in resources.items():
    model.addConstr(
        data['coefficients'][0] * fiber +
        data['coefficients'][1] * vitamin_b1 +
        data['coefficients'][2] * vitamin_e +
        data['coefficients'][3] * vitamin_b5 +
        data['coefficients'][4] * magnesium <= data['upper_bound'], name=r
    )

# Add additional constraints from the prompt (simplified to avoid redundancy)
model.addConstr(10 * vitamin_e + vitamin_b5 + 14 * magnesium >= 22)
model.addConstr(4 * vitamin_b1 + 10 * vitamin_e + vitamin_b5 >= 22)
model.addConstr(2 * fiber + 4 * vitamin_b1 + 10 * vitamin_e >= 22)
model.addConstr(2 * fiber + 4 * vitamin_b1 + 14 * magnesium >= 22)
model.addConstr(4 * vitamin_b1 + vitamin_b5 + 14 * magnesium >= 22)
model.addConstr(2 * fiber + 4 * vitamin_b1 + vitamin_b5 >= 22)
model.addConstr(2 * fiber + 10 * vitamin_e + vitamin_b5 >= 22)
model.addConstr(2 * fiber + 10 * vitamin_e + 14 * magnesium >= 22)

model.addConstr(11 * vitamin_e + 8 * vitamin_b5 + 10 * magnesium >= 23)
model.addConstr(10 * vitamin_b1 + 11 * vitamin_e + 8 * vitamin_b5 >= 23)
model.addConstr(7 * vitamin_e + 10 * vitamin_b5 >= 27)
model.addConstr(13 * fiber + 10 * vitamin_b5 >= 12)
model.addConstr(7 * vitamin_e + 8 * magnesium >= 26)
model.addConstr(7 * vitamin_b1 + 7 * vitamin_e + 10 * vitamin_b5 >= 24)

model.addConstr(2 * fiber + vitamin_b5 <= 73)
model.addConstr(2 * fiber + 10 * vitamin_e <= 80)
model.addConstr(4 * vitamin_b1 + 14 * magnesium <= 73)
model.addConstr(2 * fiber + 14 * magnesium <= 99)
model.addConstr(2 * fiber + vitamin_b5 + 14 * magnesium <= 60)
model.addConstr(4 * vitamin_b1 + 10 * vitamin_e + vitamin_b5 <= 38)
model.addConstr(4 * vitamin_b1 + 10 * vitamin_e + 14 * magnesium <= 33)
model.addConstr(2 * fiber + 10 * vitamin_e + 14 * magnesium <= 77)
model.addConstr(10 * vitamin_e + vitamin_b5 + 14 * magnesium <= 104)
model.addConstr(2 * fiber + 10 * vitamin_e + vitamin_b5 <= 82)
model.addConstr(2 * fiber + 4 * vitamin_b1 + vitamin_b5 <= 56)
model.addConstr(4 * vitamin_b1 + vitamin_b5 + 14 * magnesium <= 73)
model.addConstr(2 * fiber + 4 * vitamin_b1 + 10 * vitamin_e + vitamin_b5 + 14 * magnesium <= 73)
model.addConstr(10 * vitamin_b1 + 11 * vitamin_e <= 74)
model.addConstr(10 * vitamin_b1 + 8 * vitamin_b5 <= 96)
model.addConstr(8 * fiber + 8 * vitamin_b5 <= 65)
model.addConstr(8 * fiber + 10 * magnesium <= 65)
model.addConstr(8 * fiber + 11 * vitamin_e <= 38)
model.addConstr(11 * vitamin_e + 10 * magnesium <= 109)
model.addConstr(10 * vitamin_b1 + 10 * magnesium <= 51)
model.addConstr(8 * fiber + 10 * vitamin_b1 <= 87)
model.addConstr(10 * vitamin_b1 + 11 * vitamin_e + 8 * vitamin_b5 <= 104)
model.addConstr(8 * fiber + 10 * vitamin_b1 + 10 * magnesium <= 50)
model.addConstr(8 * fiber + 11 * vitamin_e + 8 * vitamin_b5 <= 78)
model.addConstr(8 * fiber + 10 * vitamin_b1 + 8 * vitamin_b5 <= 62)
model.addConstr(8 * fiber + 10 * vitamin_b1 + 11 * vitamin_e + 8 * vitamin_b5 + 10 * magnesium <= 62)
model.addConstr(7 * vitamin_b1 + 8 * magnesium <= 123)
model.addConstr(13 * fiber + 7 * vitamin_e <= 103)
model.addConstr(7 * vitamin_b1 + 10 * vitamin_b5 <= 142)
model.addConstr(7 * vitamin_e + 10 * vitamin_b5 <= 104)
model.addConstr(13 * fiber + 7 * vitamin_b1 + 7 * vitamin_e <= 109)
model.addConstr(13 * fiber + 7 * vitamin_e + 8 * magnesium <= 102)
model.addConstr(13 * fiber + 7 * vitamin_b1 + 7 * vitamin_e + 10 * vitamin_b5 + 8 * magnesium <= 102)



# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {model.status}")

