
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
intrusion_analysts = m.addVar(vtype=gp.GRB.INTEGER, name="intrusion_analysts")
security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
security_onions = m.addVar(vtype=gp.GRB.INTEGER, name="security_onions")
patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")


# Set objective function
m.setObjective(4*intrusion_analysts**2 + 7*intrusion_analysts*security_engineers + 8*intrusion_analysts*security_onions + 1*intrusion_analysts*patches_per_day + 5*security_engineers**2 + 6*security_engineers*security_onions + 3*security_engineers*patches_per_day + 5*security_onions**2 + 2*patches_per_day**2 + 7*intrusion_analysts + 9*security_engineers + 2*security_onions + 2*patches_per_day, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(3.06*intrusion_analysts + 8.77*patches_per_day >= 88)
m.addConstr(3.06*intrusion_analysts**2 + 9.62*security_onions**2 >= 43)
m.addConstr(9.62*security_onions**2 + 8.77*patches_per_day**2 >= 46)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 8.77*patches_per_day >= 60)
m.addConstr(9.97*security_engineers + 9.62*security_onions + 8.77*patches_per_day >= 60)
m.addConstr(3.06*intrusion_analysts + 9.62*security_onions + 8.77*patches_per_day >= 60)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 9.62*security_onions >= 60)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 8.77*patches_per_day >= 61)
m.addConstr(9.97*security_engineers + 9.62*security_onions + 8.77*patches_per_day >= 61)
m.addConstr(3.06*intrusion_analysts + 9.62*security_onions + 8.77*patches_per_day >= 61)
m.addConstr(3.06*intrusion_analysts**2 + 9.97*security_engineers**2 + 9.62*security_onions**2 >= 61)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 8.77*patches_per_day >= 84)
m.addConstr(9.97*security_engineers + 9.62*security_onions + 8.77*patches_per_day >= 84)
m.addConstr(3.06*intrusion_analysts + 9.62*security_onions + 8.77*patches_per_day >= 84)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 9.62*security_onions >= 84)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 8.77*patches_per_day >= 69)
m.addConstr(9.97*security_engineers + 9.62*security_onions + 8.77*patches_per_day >= 69)
m.addConstr(3.06*intrusion_analysts + 9.62*security_onions + 8.77*patches_per_day >= 69)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 9.62*security_onions >= 69)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 9.62*security_onions + 8.77*patches_per_day >= 69)
m.addConstr(4.1*security_onions + 2.95*patches_per_day >= 105)
m.addConstr(7.97*intrusion_analysts + 2.95*patches_per_day >= 88)
m.addConstr(1.85*security_engineers**2 + 4.1*security_onions**2 >= 109)
m.addConstr(7.97*intrusion_analysts + 1.85*security_engineers + 4.1*security_onions + 2.95*patches_per_day >= 109)
m.addConstr(9.62*security_onions**2 + 8.77*patches_per_day**2 <= 231)
m.addConstr(3.06*intrusion_analysts + 8.77*patches_per_day <= 324)
m.addConstr(9.97*security_engineers + 9.62*security_onions <= 166)
m.addConstr(9.97*security_engineers + 9.62*security_onions + 8.77*patches_per_day <= 232)
m.addConstr(3.06*intrusion_analysts + 9.97*security_engineers + 9.62*security_onions <= 334)
m.addConstr(3.06*intrusion_analysts**2 + 9.97*security_engineers**2 + 8.77*patches_per_day**2 <= 97)


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

