
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(vtype=gurobi.GRB.INTEGER, name="intrusion_analysts")
x2 = m.addVar(vtype=gurobi.GRB.INTEGER, name="security_engineers")
x3 = m.addVar(vtype=gurobi.GRB.INTEGER, name="security_onions")
x4 = m.addVar(vtype=gurobi.GRB.INTEGER, name="patches_per_day")

# Objective function
m.setObjective(4*x1**2 + 7*x1*x2 + 8*x1*x3 + x1*x4 + 5*x2**2 + 6*x2*x3 + 3*x2*x4 + 5*x3**2 + 2*x4**2 + 7*x1 + 9*x2 + 2*x3 + 2*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(3.06*x1 <= 380, name="data_integrity_impact_intrusion_analysts")
m.addConstr(7.97*x1 <= 562, name="data_confidentiality_impact_intrusion_analysts")
m.addConstr(9.97*x2 <= 380, name="data_integrity_impact_security_engineers")
m.addConstr(1.85*x2 <= 562, name="data_confidentiality_impact_security_engineers")
m.addConstr(9.62*x3 <= 380, name="data_integrity_impact_security_onions")
m.addConstr(4.1*x3 <= 562, name="data_confidentiality_impact_security_onions")
m.addConstr(8.77*x4 <= 380, name="data_integrity_impact_patches_per_day")
m.addConstr(2.95*x4 <= 562, name="data_confidentiality_impact_patches_per_day")

m.addConstr(3.06*x1 + 8.77*x4 >= 88, name="total_data_integrity_impact_intrusion_analysts_patches")
m.addConstr(3.06**2*x1**2 + 9.62**2*x3**2 >= 43, name="total_data_integrity_impact_intrusion_analysts_security_onions")
m.addConstr(9.62**2*x3**2 + 8.77**2*x4**2 >= 46, name="total_data_integrity_impact_security_onions_patches")

m.addConstr(3.06*x1 + 9.97*x2 + 8.77*x4 >= 60, name="total_data_integrity_impact_intrusion_analysts_security_engineers_patches")
m.addConstr(9.97*x2 + 9.62*x3 + 8.77*x4 >= 60, name="total_data_integrity_impact_security_engineers_security_onions_patches")
m.addConstr(3.06*x1 + 9.62*x3 + 8.77*x4 >= 60, name="total_data_integrity_impact_intrusion_analysts_security_onions_patches")
m.addConstr(3.06*x1 + 9.97*x2 + 9.62*x3 >= 60, name="total_data_integrity_impact_intrusion_analysts_security_engineers_security_onions")

m.addConstr(3.06*x1 + 9.97*x2 + 8.77*x4 >= 61, name="total_data_integrity_impact_intrusion_analysts_security_engineers_patches_61")
m.addConstr(9.97*x2 + 9.62*x3 + 8.77*x4 >= 61, name="total_data_integrity_impact_security_engineers_security_onions_patches_61")
m.addConstr(3.06*x1 + 9.62*x3 + 8.77*x4 >= 61, name="total_data_integrity_impact_intrusion_analysts_security_onions_patches_61")

m.addConstr(3.06**2*x1**2 + 9.97**2*x2**2 + 9.62**2*x3**2 >= 61, name="total_data_integrity_impact_squared")

m.addConstr(3.06*x1 + 9.97*x2 + 8.77*x4 >= 84, name="total_data_integrity_impact_84")
m.addConstr(9.97*x2 + 9.62*x3 + 8.77*x4 >= 84, name="total_data_integrity_impact_84_2")
m.addConstr(3.06*x1 + 9.62*x3 + 8.77*x4 >= 84, name="total_data_integrity_impact_84_3")
m.addConstr(3.06*x1 + 9.97*x2 + 9.62*x3 >= 84, name="total_data_integrity_impact_84_4")

m.addConstr(4.1*x3 + 2.95*x4 >= 105, name="data_confidentiality_impact_security_onions_patches")
m.addConstr(7.97*x1 + 2.95*x4 >= 88, name="data_confidentiality_impact_intrusion_analysts_patches")
m.addConstr(1.85**2*x2**2 + 4.1**2*x3**2 >= 109, name="data_confidentiality_impact_security_engineers_security_onions")
m.addConstr(7.97*x1 + 1.85*x2 + 4.1*x3 + 2.95*x4 >= 109, name="data_confidentiality_impact_all")

m.addConstr(9.62**2*x3**2 + 8.77**2*x4**2 <= 231, name="data_integrity_impact_security_onions_patches_max")
m.addConstr(3.06*x1 + 8.77*x4 <= 324, name="data_integrity_impact_intrusion_analysts_patches_max")
m.addConstr(9.97*x2 + 9.62*x3 <= 166, name="data_integrity_impact_security_engineers_security_onions_max")
m.addConstr(9.97*x2 + 9.62*x3 + 8.77*x4 <= 232, name="data_integrity_impact_security_engineers_security_onions_patches_max")
m.addConstr(3.06*x1 + 9.97*x2 + 9.62*x3 <= 334, name="data_integrity_impact_intrusion_analysts_security_engineers_security_onions_max")
m.addConstr(3.06**2*x1**2 + 9.97**2*x2**2 + 8.77**2*x4**2 <= 97, name="data_integrity_impact_squared_max")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Intrusion Analysts: ", x1.varValue)
    print("Security Engineers: ", x2.varValue)
    print("Security Onions: ", x3.varValue)
    print("Patches per Day: ", x4.varValue)
else:
    print("No solution found")
