
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    oreos = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oreos")
    strawberries = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strawberries")
    knishes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="knishes")


    # Set objective function
    m.setObjective(5.06 * oreos + 8.79 * strawberries + 3.1 * knishes, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(11 * oreos + 11 * knishes >= 77)
    m.addConstr(6 * strawberries + 11 * knishes >= 79)
    m.addConstr(10 * oreos + 11 * strawberries >= 41)
    m.addConstr(10 * oreos + 5 * knishes >= 87)
    m.addConstr(11 * strawberries + 5 * knishes >= 85)
    m.addConstr(17 * oreos + 10 * strawberries >= 38)
    m.addConstr(10 * strawberries + 5 * knishes >= 52)
    m.addConstr(9 * oreos + 3 * strawberries >= 33)
    m.addConstr(9 * oreos + 6 * knishes >= 11)
    m.addConstr(11 * oreos + 11 * knishes <= 97)
    m.addConstr(6 * strawberries + 11 * knishes <= 116)
    m.addConstr(11 * oreos + 6 * strawberries + 11 * knishes <= 241)
    m.addConstr(10 * oreos + 5 * knishes <= 166)
    m.addConstr(10 * oreos + 11 * strawberries + 5 * knishes <= 263)
    m.addConstr(17 * oreos + 10 * strawberries <= 234)
    m.addConstr(10 * strawberries + 5 * knishes <= 117)
    m.addConstr(17 * oreos + 5 * knishes <= 243)
    m.addConstr(17 * oreos + 10 * strawberries + 5 * knishes <= 243)
    m.addConstr(9 * oreos + 6 * knishes <= 95)
    m.addConstr(3 * strawberries + 6 * knishes <= 86)
    m.addConstr(9 * oreos + 3 * strawberries + 6 * knishes <= 86)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
