
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="oreos", lb=-gurobi.GRB.INFINITY)
x1 = m.addVar(name="strawberries", lb=-gurobi.GRB.INFINITY)
x2 = m.addVar(name="knishes", lb=-gurobi.GRB.INFINITY)

# Set the objective function
m.setObjective(5.06 * x0 + 8.79 * x1 + 3.1 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * x0 + 11 * x2 >= 77)
m.addConstr(6 * x1 + 11 * x2 >= 79)
m.addConstr(10 * x0 + 11 * x1 >= 41)
m.addConstr(10 * x0 + 5 * x2 >= 87)
m.addConstr(11 * x1 + 5 * x2 >= 85)
m.addConstr(17 * x0 + 10 * x1 >= 38)
m.addConstr(10 * x1 + 5 * x2 >= 52)
m.addConstr(9 * x0 + 3 * x1 >= 33)
m.addConstr(9 * x0 + 6 * x2 >= 11)
m.addConstr(11 * x0 + 11 * x2 <= 97)
m.addConstr(6 * x1 + 11 * x2 <= 116)
m.addConstr(11 * x0 + 6 * x1 + 11 * x2 <= 241)
m.addConstr(11 * x0 <= 293)
m.addConstr(10 * x0 + 11 * x1 + 5 * x2 <= 290)
m.addConstr(17 * x0 + 10 * x1 + 5 * x2 <= 254)
m.addConstr(9 * x0 + 3 * x1 + 6 * x2 <= 103)
m.addConstr(10 * x0 + 5 * x2 <= 166)
m.addConstr(10 * x0 + 11 * x1 + 5 * x2 <= 263)
m.addConstr(17 * x0 + 10 * x1 <= 234)
m.addConstr(10 * x1 + 5 * x2 <= 117)
m.addConstr(17 * x0 + 5 * x2 <= 243)
m.addConstr(9 * x0 + 6 * x2 <= 95)
m.addConstr(3 * x1 + 6 * x2 <= 86)
m.addConstr(9 * x0 + 3 * x1 + 6 * x2 <= 86)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Oreos: ", x0.varValue)
    print("Strawberries: ", x1.varValue)
    print("Knishes: ", x2.varValue)
else:
    print("The model is infeasible.")
