
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
x0 = model.addVar(vtype=gp.GRB.INTEGER, name="packs of paper plates")
x1 = model.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
x2 = model.addVar(vtype=gp.GRB.INTEGER, name="packs of napkins")
x3 = model.addVar(vtype=gp.GRB.INTEGER, name="dish soap bottles")
x4 = model.addVar(vtype=gp.GRB.INTEGER, name="rubber gloves")


# Set objective function
model.setObjective(8.25 * x0 + 3.87 * x1 + 8.99 * x2 + 5.31 * x3 + 9.91 * x4, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(4 * x0 + 11 * x1 + 13 * x2 + 13 * x3 + 8 * x4 <= 163, "storage space")
model.addConstr(8 * x0 + 7 * x1 + 6 * x2 + 3 * x3 + 12 * x4 <= 188, "weight")

# ... (rest of the constraints from the JSON "constraints" section)
# Example:
model.addConstr(11 * x1 + 13 * x2 + 8 * x4 >= 26, "c1")
# ... add all other constraints similarly

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"packs of paper plates: {x0.x}")
    print(f"lightbulbs: {x1.x}")
    print(f"packs of napkins: {x2.x}")
    print(f"dish soap bottles: {x3.x}")
    print(f"rubber gloves: {x4.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

