
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
kiwis = m.addVar(vtype=gp.GRB.INTEGER, name="kiwis")
chicken_drumsticks = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
ravioli = m.addVar(vtype=gp.GRB.INTEGER, name="ravioli")
oranges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oranges")

# Set objective function
m.setObjective(1*kiwis + 8*chicken_drumsticks + 5*ravioli + 6*oranges, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(8*kiwis + 8*oranges >= 12)
m.addConstr(8*kiwis + 8*chicken_drumsticks + 8*oranges >= 9)
m.addConstr(8*chicken_drumsticks + 8*ravioli + 8*oranges >= 9)
m.addConstr(8*kiwis + 8*chicken_drumsticks + 8*oranges >= 11)
m.addConstr(8*chicken_drumsticks + 8*ravioli + 8*oranges >= 11)
m.addConstr(8*kiwis + 5*chicken_drumsticks + 2*ravioli >= 10)
m.addConstr(8*kiwis + 8*oranges >= 5)
m.addConstr(8*kiwis + 2*chicken_drumsticks >= 6)
m.addConstr(2*chicken_drumsticks + 8*ravioli >= 11)
m.addConstr(8*ravioli + 8*oranges >= 7)
m.addConstr(2*chicken_drumsticks + 8*oranges >= 5)
m.addConstr(8*kiwis + 8*ravioli <= 31)
m.addConstr(8*ravioli + 8*oranges <= 41)
m.addConstr(8*chicken_drumsticks + 8*oranges <= 24)
m.addConstr(8*kiwis + 8*chicken_drumsticks <= 26)
m.addConstr(8*kiwis + 8*chicken_drumsticks + 8*oranges <= 48)
m.addConstr(8*kiwis + 8*chicken_drumsticks + 8*ravioli + 8*oranges <= 48)
m.addConstr(8*kiwis + 2*oranges <= 40)
m.addConstr(5*chicken_drumsticks + 2*ravioli <= 43)
m.addConstr(8*kiwis + 5*chicken_drumsticks <= 31)
m.addConstr(8*kiwis + 5*chicken_drumsticks + 2*oranges <= 26)
m.addConstr(8*kiwis + 5*chicken_drumsticks + 2*ravioli <= 34)
m.addConstr(5*chicken_drumsticks + 2*ravioli + 2*oranges <= 35)
m.addConstr(8*kiwis + 2*ravioli + 2*oranges <= 20)
m.addConstr(8*kiwis + 5*chicken_drumsticks + 2*ravioli + 2*oranges <= 20)
m.addConstr(8*ravioli + 8*oranges <= 40)
m.addConstr(2*chicken_drumsticks + 8*ravioli <= 29)
m.addConstr(8*kiwis + 2*chicken_drumsticks <= 44)
m.addConstr(8*kiwis + 8*ravioli <= 30)
m.addConstr(8*kiwis + 8*oranges <= 22)
m.addConstr(2*chicken_drumsticks + 8*oranges <= 38)
m.addConstr(8*kiwis + 2*chicken_drumsticks + 8*ravioli + 8*oranges <= 38)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

