
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='kiwis', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name='chicken drumsticks', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name='ravioli', lb=0, ub=None, vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name='oranges', lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS)

# Objective function
m.setObjective(x0 + 8*x1 + 5*x2 + 6*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(8*x0 + 8*x1 + 8*x2 + 8*x3 <= 50)
m.addConstr(8*x0 + 5*x1 + 2*x2 + 2*x3 <= 61)
m.addConstr(8*x0 + 2*x1 + 8*x2 + 8*x3 <= 48)
m.addConstr(8*x0 + 8*x3 >= 12)
m.addConstr(8*x0 + 8*x1 + 8*x3 >= 9)
m.addConstr(8*x1 + 8*x2 + 8*x3 >= 9)
m.addConstr(8*x0 + 8*x1 + 8*x3 >= 11)
m.addConstr(8*x1 + 8*x2 + 8*x3 >= 11)
m.addConstr(8*x0 + 5*x1 + 2*x2 >= 10)
m.addConstr(8*x0 + 8*x3 >= 5)
m.addConstr(8*x0 + 2*x1 >= 6)
m.addConstr(2*x1 + 8*x2 >= 11)
m.addConstr(8*x2 + 8*x3 >= 7)
m.addConstr(2*x1 + 8*x3 >= 5)
m.addConstr(8*x0 + 8*x2 <= 31)
m.addConstr(8*x2 + 8*x3 <= 41)
m.addConstr(8*x1 + 8*x3 <= 24)
m.addConstr(8*x0 + 8*x1 <= 26)
m.addConstr(8*x0 + 8*x1 + 8*x3 <= 48)
m.addConstr(8*x0 + 8*x1 + 8*x2 + 8*x3 <= 48)
m.addConstr(8*x0 + 2*x3 <= 40)
m.addConstr(5*x1 + 2*x2 <= 43)
m.addConstr(8*x0 + 5*x1 <= 31)
m.addConstr(8*x0 + 5*x1 + 2*x3 <= 26)
m.addConstr(8*x0 + 5*x1 + 2*x2 <= 34)
m.addConstr(5*x1 + 2*x2 + 2*x3 <= 35)
m.addConstr(8*x0 + 2*x2 + 2*x3 <= 20)
m.addConstr(8*x0 + 5*x1 + 2*x2 + 2*x3 <= 20)
m.addConstr(8*x2 + 8*x3 <= 40)
m.addConstr(2*x1 + 8*x2 <= 29)
m.addConstr(8*x0 + 2*x1 <= 44)
m.addConstr(8*x0 + 8*x2 <= 30)
m.addConstr(8*x0 + 8*x3 <= 22)
m.addConstr(2*x1 + 8*x3 <= 38)
m.addConstr(8*x0 + 2*x1 + 8*x2 + 8*x3 <= 38)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Kiwis: ', x0.varValue)
    print('Chicken drumsticks: ', x1.varValue)
    print('Ravioli: ', x2.varValue)
    print('Oranges: ', x3.varValue)
else:
    print('No solution found')
