
from gurobipy import *

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="SOC_operators")
x1 = m.addVar(vtype=GRB.INTEGER, name="patches_per_day")
x2 = m.addVar(vtype=GRB.INTEGER, name="Mbps_bandwidth_allocated_to_monitoring")
x3 = m.addVar(vtype=GRB.INTEGER, name="system_administrators")
x4 = m.addVar(vtype=GRB.INTEGER, name="automatic_alerts")
x5 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")
x6 = m.addVar(vtype=GRB.INTEGER, name="pen_testers")


# Set objective function
m.setObjective(6*x0 + 8*x1 + 9*x2 + 2*x3 + 4*x4 + 9*x5 + 5*x6, GRB.MAXIMIZE)

# Add constraints
m.addConstr(16*x0 + 13*x1 + 12*x2 + 22*x3 + 8*x4 + 21*x5 + 12*x6 <= 267, "c0")
m.addConstr(1*x0 + 16*x1 + 2*x2 + 16*x3 + 19*x4 + 25*x5 + 15*x6 <= 343, "c1")
m.addConstr(12*x0 + 7*x1 + 8*x2 + 17*x3 + 17*x4 + 5*x5 + 23*x6 <= 415, "c2")

# ... (rest of the constraints as derived from the symbolic representation)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

