
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x = model.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bill", "Laura", "Dale", "Peggy"])


    # Set objective function
    obj = 4*x[0]**2 + 9*x[0]*x[1] + 6*x[0]*x[2] + 1*x[0]*x[3] + 6*x[1]**2 + 4*x[1]*x[2] + 6*x[1]*x[3] + 5*x[2]**2 + 2*x[2]*x[3] + 7*x[3]**2 + 1*x[0] + 7*x[1] + 7*x[2] + 4*x[3]
    model.setObjective(obj, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(19*x[0] + 6*x[1] >= 27)
    model.addConstr(6*x[1]**2 + 16*x[3]**2 >= 20)
    model.addConstr(19*x[0] + 6*x[1] + 5*x[2] >= 24)
    model.addConstr(6*x[1]**2 + 5*x[2]**2 <= 106)
    model.addConstr(6*x[1]**2 + 16*x[3]**2 <= 90)
    model.addConstr(6*x[1] + 5*x[2] + 16*x[3] <= 55)
    model.addConstr(19*x[0] + 6*x[1] + 16*x[3] <= 159)
    model.addConstr(19*x[0] + 6*x[1] + 5*x[2] + 16*x[3] <= 159)
    model.addConstr(9*x[0]**2 + 3*x[2]**2 <= 105)
    model.addConstr(9*x[0] + 20*x[3] <= 52)
    model.addConstr(3*x[2] + 20*x[3] <= 62)
    model.addConstr(5*x[1] + 20*x[3] <= 100)
    model.addConstr(9*x[0] + 5*x[1] + 3*x[2] + 20*x[3] <= 100)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
        print('Obj: %g' % model.objVal)
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
